library(dygraphs)
library(xts)
library(dplyr)
library(zoo)
library(padr)
library(ggplot2)

#IMPORT AND FORMAT JBT05 AND JBT14, SUM FLOW BY DAY
getwd()
setwd("O:/Proj-15/WRM/15-309 LCBP Jewett Brook Tile Drain Study/Data/Loading Calcs/FlowLinkEditedFiles/R")

JBT05Flw <- read.csv(file="JBT05_FlowMeter_forR.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05Flw$DT<-as.POSIXct(JBT05Flw$Datetime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

JBT14Flw <- read.csv(file="JBT14_forR.csv", header=TRUE,stringsAsFactors=FALSE)
JBT14Flw$DT<-as.POSIXct(JBT14Flw$Datetime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

get_interval(JBT05Flw$DT)
get_interval(JBT14Flw$DT)

JBT05flowdailysum<-JBT05Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(jbt05sumflow=sum(Noise.Removed.Flow.L.15min))
JBT14flowdailysum<-JBT14Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(jbt14sumflow=sum(Noise.Removed.Flow.L.15min))

jbt14jbt05<-merge(JBT05flowdailysum,JBT14flowdailysum,by="DT_day") 

#Scatter plot, regression, trendlines, residual plots
ggplot(jbt14jbt05, aes(x=jbt14sumflow, y=jbt05sumflow)) + geom_point()
write.csv(jbt14jbt05, "jbt14jbt05_dailylowcompare_rexport.csv")

#jbt14 plot
JBT14Graph<-xts(x=JBT14Flw$Noise.Removed.Flow.L.15min,order.by=JBT14Flw$DT)
dygraph(JBT14Graph)
